-------------------------------------------------------------------------------
-- $RCSfile: cordic_v4_0_pack.vhd,v $ $Revision: 1.4 $ $Date: 2009/12/04 11:46:47 $
-------------------------------------------------------------------------------
-- (c) Copyright 2006 - 2008 Xilinx, Inc. All rights reserved.
--
-- This file contains confidential and proprietary information
-- of Xilinx, Inc. and is protected under U.S. and
-- international copyright and other intellectual property
-- laws.
--
-- DISCLAIMER
-- This disclaimer is not a license and does not grant any
-- rights to the materials distributed herewith. Except as
-- otherwise provided in a valid license issued to you by
-- Xilinx, and to the maximum extent permitted by applicable
-- law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
-- WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
-- AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
-- BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
-- INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
-- (2) Xilinx shall not be liable (whether in contract or tort,
-- including negligence, or under any other theory of
-- liability) for any loss or damage of any kind or nature
-- related to, arising under or in connection with these
-- materials, including for any direct, or any indirect,
-- special, incidental, or consequential loss or damage
-- (including loss of data, profits, goodwill, or any type of
-- loss or damage suffered as a result of any action brought
-- by a third party) even if such damage or loss was
-- reasonably foreseeable or Xilinx had been advised of the
-- possibility of the same.
--
-- CRITICAL APPLICATIONS
-- Xilinx products are not designed or intended to be fail-
-- safe, or for use in any application requiring fail-safe
-- performance, such as life-support or safety devices or
-- systems, Class III medical devices, nuclear facilities,
-- applications related to the deployment of airbags, or any
-- other applications that could lead to death, personal
-- injury, or severe property or environmental damage
-- (individually and collectively, "Critical
-- Applications"). Customer assumes the sole risk and
-- liability of any use of Xilinx products in Critical
-- Applications, subject only to applicable laws and
-- regulations governing limitations on product liability.
--
-- THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
-- PART OF THIS FILE AT ALL TIMES
-------------------------------------------------------------------------------
-- Description:
--    ******* WARNING: AUTOMATICALLY GENERATED FILE: Do not manually edit  ********************
--                     
--         Use script: cordc_v4_0/auto_gen_scripts/sim_package/gen_sim_package to regenerate
--
-------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

library xilinxcorelib;
use xilinxcorelib.bip_utils_pkg_v2_0.all;
use xilinxcorelib.mult_gen_pkg_v11_0.all;

-------------------------------------------------------------------------------
package cordic_v4_0_pack is

--------------------------------------------------------------------------------
--From:  ../../hdl/cordic_pack.vhd

  FUNCTION check_generics ( c_architecture,
                            c_cordic_function,
                            c_coarse_rotate,
                            c_data_format,
                            c_has_ce,
                            c_has_clk,
                            c_has_nd,
                            c_has_phase_in,
                            c_has_phase_out,
                            c_has_rdy,
                            c_has_rfd,
                            c_has_sclr,
                            c_has_x_in,
                            c_has_x_out,
                            c_has_y_in,
                            c_has_y_out,
                            c_input_width,
                            c_iterations,
                            c_output_width,
                            c_phase_format,
                            c_pipeline_mode,
                            c_precision,
                            c_reg_inputs,
                            c_reg_outputs,
                            c_round_mode,
                            c_scale_comp
                            : integer) RETURN BOOLEAN;

  function check_boolean_range( generic_value: integer; generic_string: string) return boolean;

  FUNCTION CORDIC_PACK_funct_has_port(cordic_funct, position: INTEGER) RETURN INTEGER;

  FUNCTION CORDIC_PACK_get_transform_type(cordic_funct : INTEGER)RETURN INTEGER;

  FUNCTION CORDIC_PACK_get_eng_mode(cordic_funct: INTEGER) RETURN STD_LOGIC;

  FUNCTION CORDIC_PACK_get_iterations_int(  coarse_rotate : INTEGER; 
                                            cordic_funct  : INTEGER; 
                                            iterations    : INTEGER; 
                                            output_width  : INTEGER; 
                                            round_mode    : INTEGER) RETURN INTEGER;

  FUNCTION CORDIC_PACK_get_precision_int( cordic_funct   : INTEGER; 
                                          data_format    : INTEGER;
                                          input_width    : INTEGER;
                                          iterations_int : INTEGER; 
                                          output_width   : INTEGER; 
                                          precision      : INTEGER; 
                                          round_mode     : INTEGER) RETURN INTEGER;

  FUNCTION CORDIC_PACK_get_rnd_mode_int(cordic_funct : INTEGER; round_mode : INTEGER) RETURN INTEGER;

  FUNCTION CORDIC_PACK_gen_ctrl_width(coarse_rotate : INTEGER) RETURN INTEGER;

  FUNCTION CORDIC_PACK_get_current_iteration(I : INTEGER;transform_type : INTEGER)RETURN INTEGER;

  FUNCTION CORDIC_PACK_get_round_ext(round_mode : INTEGER) RETURN INTEGER;

  FUNCTION CORDIC_PACK_get_rnd_pipe_int(p_pipeline_mode:INTEGER; p_reg_outputs:INTEGER)RETURN INTEGER;

  FUNCTION CORDIC_PACK_get_ccm_imp(scale_comp : INTEGER) RETURN INTEGER;

  FUNCTION getLatency(  architecture_sel : INTEGER; 
                        coarse_rotate : INTEGER; 
                        cordic_function : INTEGER;
                        data_format : INTEGER; 
                        family : STRING; 
                        input_width : INTEGER; 
                        iterations : INTEGER; 
                        output_width : INTEGER;
                        pipeline_mode : INTEGER; 
                        precision : INTEGER; 
                        reg_inputs : INTEGER; 
                        reg_outputs: INTEGER;
                        round_mode : INTEGER; 
                        scale_comp : INTEGER) RETURN INTEGER;

  FUNCTION CORDIC_PACK_get_inp_config_latency(  architecture_sel : INTEGER; 
                                                coarse_rotate : INTEGER; 
                                                cordic_function : INTEGER; 
                                                pipeline_mode : INTEGER; 
                                                reg_inputs : INTEGER) RETURN INTEGER;

  FUNCTION CORDIC_PACK_get_engine_latency(architecture_sel : INTEGER; iterations_int : INTEGER; pipeline_mode : INTEGER) RETURN INTEGER;

  FUNCTION CORDIC_PACK_get_out_config_latency(  family: string; 
                                                architecture_sel : INTEGER;
                                                coarse_rotate : INTEGER; 
                                                cordic_function : INTEGER; 
                                                iterations_int : INTEGER; 
                                                pipeline_mode : INTEGER; 
                                                precision_int : INTEGER;
                                                reg_outputs : INTEGER; 
                                                round_mode : INTEGER; 
                                                scale_comp_int : INTEGER) RETURN INTEGER;

  FUNCTION CORDIC_PACK_get_scale_latency( family: string; 
                                          cordic_function : INTEGER; 
                                          precision_int : INTEGER; 
                                          iterations_int : INTEGER;
                                          pipeline_mode: INTEGER;
                                          scale_comp_int: INTEGER; 
                                          sign: integer) RETURN INTEGER;

  FUNCTION CORDIC_PACK_get_round_latency(pipeline_mode : INTEGER; round_mode : INTEGER) RETURN INTEGER;

  FUNCTION CORDIC_PACK_get_sqrt_latency(  data_format:INTEGER;
                                          input_width:INTEGER;
                                          output_width:INTEGER;
                                          pipeline_mode:integer;
                                          precision_int:integer;
                                          reg_inputs:integer; 
                                          reg_outputs:integer;
                                          round_mode:INTEGER) RETURN INTEGER;

  FUNCTION CORDIC_PACK_get_rfd_latency( architecture_sel : INTEGER;
                                        coarse_rotate : INTEGER;
                                        cordic_function : INTEGER;
                                        iterations_int : INTEGER;
                                        pipeline_mode : INTEGER;
                                        reg_inputs : INTEGER) RETURN INTEGER;

  FUNCTION CORDIC_PACK_slv_to_str(a: STD_LOGIC_VECTOR; len: INTEGER) RETURN STRING;

  FUNCTION CORDIC_PACK_int_to_sl(a : INTEGER) RETURN STD_LOGIC;

  FUNCTION CORDIC_PACK_real_to_slv(a:REAL; len:INTEGER; fmt:INTEGER) RETURN STD_LOGIC_VECTOR;

  FUNCTION CORDIC_PACK_slv_to_real(a:STD_LOGIC_VECTOR; len: INTEGER; fmt:INTEGER) RETURN REAL;

  FUNCTION CORDIC_PACK_rnd_slv(a : IN STD_LOGIC_VECTOR; len: IN INTEGER; mode : IN INTEGER; precision : IN INTEGER) RETURN STD_LOGIC_VECTOR;

  FUNCTION CORDIC_PACK_add_sub_signed_slv(a : STD_LOGIC_VECTOR; a_len: INTEGER; b : STD_LOGIC_VECTOR; b_len: INTEGER; 
                                          add_nsub : STD_LOGIC; c : STD_LOGIC) RETURN STD_LOGIC_VECTOR;

  FUNCTION CORDIC_PACK_cordic_scale_slv(cordic_funct : IN INTEGER; iterations_int : IN INTEGER; precision_int : IN INTEGER) RETURN STD_LOGIC_VECTOR;

  FUNCTION CORDIC_PACK_inv_cordic_scale_slv(cordic_funct : IN INTEGER; iterations_int : IN INTEGER; precision_int : IN INTEGER) RETURN STD_LOGIC_VECTOR;

  FUNCTION CORDIC_PACK_inv_cordic_scale_str(cordic_funct : IN INTEGER; iterations_int : IN INTEGER; precision_int : IN INTEGER) RETURN STRING;

  FUNCTION CORDIC_PACK_rshift_slv(a : IN STD_LOGIC_VECTOR; shift : IN INTEGER) RETURN STD_LOGIC_VECTOR;

  CONSTANT CORDIC_PACK_f_rotate : INTEGER := 0; 

  CONSTANT CORDIC_PACK_f_translate : INTEGER := 1;

  CONSTANT CORDIC_PACK_f_sin_cos : INTEGER := 2;

  CONSTANT CORDIC_PACK_f_atan : INTEGER := 3;

  CONSTANT CORDIC_PACK_f_sinh_cosh : INTEGER := 4;

  CONSTANT CORDIC_PACK_f_atanh : INTEGER := 5;

  CONSTANT CORDIC_PACK_f_sqrt : INTEGER := 6;

  CONSTANT CORDIC_PACK_f_default : INTEGER := 7;

  CONSTANT CORDIC_PACK_bser_arch : INTEGER := 0; -- Select Bit Serial Architecture (Not Implemented)

  CONSTANT CORDIC_PACK_wser_arch : INTEGER := 1; -- Select Word Serial Architecture

  CONSTANT CORDIC_PACK_para_arch : INTEGER := 2; -- Select Parallel Aarchitecture

  CONSTANT CORDIC_PACK_format_sig_frac : INTEGER := 0;

  CONSTANT CORDIC_PACK_format_usig_frac : INTEGER := 1;

  CONSTANT CORDIC_PACK_format_usig_int : INTEGER := 2;

  CONSTANT CORDIC_PACK_format_rad : INTEGER := 0;

  CONSTANT CORDIC_PACK_format_sca : INTEGER := 1;

  CONSTANT CORDIC_PACK_data_width_max : INTEGER := 64;   

  CONSTANT CORDIC_PACK_round_truncate : INTEGER := 0;

  CONSTANT CORDIC_PACK_round_pos_inf: INTEGER := 1;

  CONSTANT CORDIC_PACK_round_pos_neg_inf : INTEGER := 2;

  CONSTANT CORDIC_PACK_round_nearest_even : INTEGER := 3;

  CONSTANT CORDIC_PACK_scale_none : INTEGER := 0;

  CONSTANT CORDIC_PACK_scale_lut: INTEGER := 1;

  CONSTANT CORDIC_PACK_scale_bram: INTEGER := 2;

  CONSTANT CORDIC_PACK_scale_emb_mult: INTEGER := 3;

  CONSTANT CORDIC_PACK_pipe_none : INTEGER := 0;

  CONSTANT CORDIC_PACK_pipe_opt: INTEGER := -1;

  CONSTANT CORDIC_PACK_pipe_max: INTEGER := -2;

  CONSTANT CORDIC_PACK_x_in_port : INTEGER := 5;

  CONSTANT CORDIC_PACK_y_in_port : INTEGER := 4;

  CONSTANT CORDIC_PACK_pha_in_port : INTEGER := 3;

  CONSTANT CORDIC_PACK_x_out_port : INTEGER := 2;

  CONSTANT CORDIC_PACK_y_out_port : INTEGER := 1;

  CONSTANT CORDIC_PACK_pha_out_port : INTEGER := 0;

  CONSTANT CORDIC_PACK_em_rotational : STD_LOGIC := '0';

  CONSTANT CORDIC_PACK_em_translation : STD_LOGIC := '1';

  CONSTANT CORDIC_PACK_trig_transform : INTEGER := 0;

  CONSTANT CORDIC_PACK_hyp_transform : INTEGER := 1;

  CONSTANT CORDIC_PACK_new_line : STRING(1 TO 1) := (1 => lf); -- For assertion reports

  CONSTANT CORDIC_PACK_cordic_io_cnt : INTEGER := 6;

  CONSTANT CORDIC_PACK_max_rom_width : INTEGER := 72;

  CONSTANT CORDIC_PACK_max_rom_length : INTEGER := 64;

  CONSTANT CORDIC_PACK_cordic_scale_trig_const_slv : 
    STD_LOGIC_VECTOR(CORDIC_PACK_max_rom_width*CORDIC_PACK_max_rom_length-1 DOWNTO 0) :=
  ("010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000010" &
   "010010101000011000011011110100111101000001000111100001000011100010000001" &
   "010010101000011000011011110100111101000001000111100001000011100001110110" &
   "010010101000011000011011110100111101000001000111100001000011100001010010" &
   "010010101000011000011011110100111101000001000111100001000011011110111100" &
   "010010101000011000011011110100111101000001000111100001000011010101101001" &
   "010010101000011000011011110100111101000001000111100001000010110000011000" &
   "010010101000011000011011110100111101000001000111100001000000011011010100" &
   "010010101000011000011011110100111101000001000111100000110111000111001001" &
   "010010101000011000011011110100111101000001000111100000010001110110010111" &
   "010010101000011000011011110100111101000001000111011101111100110011010101" &
   "010010101000011000011011110100111101000001000111010100101000100111000111" &
   "010010101000011000011011110100111101000001000110101111010111110110001111" &
   "010010101000011000011011110100111101000001000100011010010100110010110001" &
   "010010101000011000011011110100111101000000111011000110001000100100110100" &
   "010010101000011000011011110100111101000000010101110101010111101101001011" &
   "010010101000011000011011110100111100111110000000110010010100001110100101" &
   "010010101000011000011011110100111100110100101100100110000110010100000101" &
   "010010101000011000011011110100111100001111011011110101001110101010001110" &
   "010010101000011000011011110100111001111010011000110001110000000011001000" &
   "010010101000011000011011110100110000100110001100100011110101101101001001" &
   "010010101000011000011011110100001011010101011011101100001101111011101111" &
   "010010101000011000011011110001110110010010011000001110001000011101101000" &
   "010010101000011000011011101000100010000110001010011100001100011101100110" &
   "010010101000011000011011000011010001010101010100111010111010100011110011" &
   "010010101000011000011000101110001110010010011000011101010100011011111010" &
   "010010101000011000001111011010000010001101000000011111001110101100011011" &
   "010010101000010111101010001001010011011101111110100110011100100000011001" &
   "010010101000010101010101000110110010001001010001110101010100100001000110" &
   "010010101000001100000001000011000110101000000100001001101001110001000101" &
   "010010100111100110110010011010101111110101101101110010101000000111001011" &
   "010010100101010010010001011010000011100100011010011101001100101001000111" &
   "010010011100000110100000100001100100000010111010011010001000011111111011" &
   "010001111000110111011110011011100101111111010010100111110000010101111101");

  CONSTANT CORDIC_PACK_cordic_scale_hyp_const_slv :
    STD_LOGIC_VECTOR(CORDIC_PACK_max_rom_width*CORDIC_PACK_max_rom_length-1 DOWNTO 0) :=
  ("001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011100" &
   "001101010000000010010000000111101100110011010011000111001100001100011101" &
   "001101010000000010010000000111101100110011010011000111001100001100011110" &
   "001101010000000010010000000111101100110011010011000111001100001100100101" &
   "001101010000000010010000000111101100110011010011000111001100001100111111" &
   "001101010000000010010000000111101100110011010011000111001100001110101001" &
   "001101010000000010010000000111101100110011010011000111001100010101010001" &
   "001101010000000010010000000111101100110011010011000111001100101111110001" &
   "001101010000000010010000000111101100110011010011000111001110011001110010" &
   "001101010000000010010000000111101100110011010011000111010101000001110011" &
   "001101010000000010010000000111101100110011010011000111101111100001110111" &
   "001101010000000010010000000111101100110011010011001001011001100010001001" &
   "001101010000000010010000000111101100110011010011010000000001100011010001" &
   "001101010000000010010000000111101100110011010011101010100001100111110010" &
   "001101010000000010010000000111101100110011010101010100100001111001110011" &
   "001101010000000010010000000111101100110011011011111100100011000001110110" &
   "001101010000000010010000000111101100110011110110011100100111100010000110" &
   "001101010000000010010000000111101100110101100000011100111001100011000011" &
   "001101010000000010010000000111101100111100001000011110000001100110111010" &
   "001101010000000010010000000111101101010110101000100010100001110110010101" &
   "001101010000000010010000000111101111000000101000110100100010110100010100" &
   "001101010000000010010000000111110101101000101001111100100110110000110010" &
   "001101010000000010010000001000010000001000101110011100110111101011100100" &
   "001101010000000010010000001001111010001001000000011110001101100100101101" &
   "001101010000000010010000001011100100001001010010011111110000101101111000" &
   "001101010000000010010000010010001100001010011010101010100000110011011000" &
   "001101010000000010010000101100101100001110111100011110011001010101110011" &
   "001101010000000010010010010110101100100001010101111011111110101010100011" &
   "001101010000000010011000111110101101101111011111010011001010010111000010" &
   "001101010000000010110011011110110011110000111101000001001000001110111001" &
   "001101010000000100011101011111011110000100111011110101011111110110110000" &
   "001101010000001011000101100110101010111010011111000000110010001101101010" &
   "001101010000100101100111001100011011010011101000011100000010001010010110" &
   "001101010010001111111111110110010111010111110011011100110100010001011101" &
   "001101010011111010100101110101111000110001110100111001010000011110011110" &
   "001101011010101001100110110100101100011111011101111101110100010000011101" &
   "001101110110110011110101110100001011000010011001010101001110011101100100");

   CONSTANT CORDIC_PACK_inv_cordic_scale_trig_const_slv : 
     STD_LOGIC_VECTOR(CORDIC_PACK_max_rom_width*CORDIC_PACK_max_rom_length-1 DOWNTO 0) :=
  ("001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011010" &
   "001101101111011001010110110001011001110111110000010011011011101011011011" &
   "001101101111011001010110110001011001110111110000010011011011101011100011" &
   "001101101111011001010110110001011001110111110000010011011011101011111110" &
   "001101101111011001010110110001011001110111110000010011011011101101101100" &
   "001101101111011001010110110001011001110111110000010011011011110100100011" &
   "001101101111011001010110110001011001110111110000010011011100010000000010" &
   "001101101111011001010110110001011001110111110000010011011101111101111110" &
   "001101101111011001010110110001011001110111110000010011100100110101101010" &
   "001101101111011001010110110001011001110111110000010100000000010100011101" &
   "001101101111011001010110110001011001110111110000010101101110001111100111" &
   "001101101111011001010110110001011001110111110000011100100101111100010011" &
   "001101101111011001010110110001011001110111110000111000000100101111000000" &
   "001101101111011001010110110001011001110111110010100101111111111001110110" &
   "001101101111011001010110110001011001110111111001011101101100100101010001" &
   "001101101111011001010110110001011001111000010100111100011111010010110011" &
   "001101101111011001010110110001011001111010000010110111101010001000111101" &
   "001101101111011001010110110001011010000000111010100100010101100001101011" &
   "001101101111011001010110110001011010011100011001010111000011000100011110" &
   "001101101111011001010110110001011100001010010100100001111001001111101011" &
   "001101101111011001010110110001100011000010000001001101010001111100000011" &
   "001101101111011001010110110001111110100000110011111010110100100110101000" &
   "001101101111011001010110110011101100011011111110110000111101100011000010" &
   "001101101111011001010110111010100100001000101010001001000101110101110110" &
   "001101101111011001010111010110000010111011010111100010101111010100011100" &
   "001101101111011001011001000011111110000110001011011011011010000100100110" &
   "001101101111011001011111111011101010110000111111011111010010111000110000" &
   "001101101111011001111011011010011101010101011000000010101011111101111101" &
   "001101101111011011101001010101100101111000111111100110100111001110110001" &
   "001101101111100010100001000001101100101001001100010101100110100010000101" &
   "001101101111111101111111101011010000011110011111100101010100101001000100" &
   "001101110001101011111000100100000101110000000001010000111101000101001111" &
   "001101111000100011000001001001011101011001100010001100001001011010010001" &
   "001110010011111001001011100010110111111111011011101100100110101011001010");

  CONSTANT CORDIC_PACK_inv_cordic_scale_hyp_const_slv : 
    STD_LOGIC_VECTOR(CORDIC_PACK_max_rom_width*CORDIC_PACK_max_rom_length-1 DOWNTO 0) :=
  ("010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011001" &
   "010011010100011110100001110010000000001110111011000010001100101001011000" &
   "010011010100011110100001110010000000001110111011000010001100101001010110" &
   "010011010100011110100001110010000000001110111011000010001100101001001100" &
   "010011010100011110100001110010000000001110111011000010001100101000100110" &
   "010011010100011110100001110010000000001110111011000010001100100110001100" &
   "010011010100011110100001110010000000001110111011000010001100011100100010" &
   "010011010100011110100001110010000000001110111011000010001011110101111001" &
   "010011010100011110100001110010000000001110111011000010001001011011010100" &
   "010011010100011110100001110010000000001110111011000001111111110001000101" &
   "010011010100011110100001110010000000001110111011000001011001001000001000" &
   "010011010100011110100001110010000000001110111010111110111110100100010100" &
   "010011010100011110100001110010000000001110111010110101010100010101000011" &
   "010011010100011110100001110010000000001110111010001110101011010111111111" &
   "010011010100011110100001110010000000001110110111110100000111100011110000" &
   "010011010100011110100001110010000000001110101110001001111000010010111001" &
   "010011010100011110100001110010000000001110000111100000111011001111010100" &
   "010011010100011110100001110010000000001011101100111101000111000001000101" &
   "010011010100011110100001110010000000000010000010101101110110001000000100" &
   "010011010100011110100001110001111111011011011001110000110010100100000011" &
   "010011010100011110100001110001111101000000110101111100100100010011111110" &
   "010011010100011110100001110001110011010110100110101011101011010011000011" &
   "010011010100011110100001110001001100101101101001101000000111000101101100" &
   "010011010100011110100001101110110010001001110101011001110011110101110000" &
   "010011010100011110100001101100010111100110000001001011110011111010010011" &
   "010011010100011110100001100010101101010110110000010011001101100011011101" &
   "010011010100011110100000111100000100011001101100100111001001111000111001" &
   "010011010100011110011110100001100000100101011011011100010111011001101000" &
   "010011010100011110010100110111010001010011110000001000001111101010011101" &
   "010011010100011101101110001110010100000011011000100111110001001001101101" &
   "010011010100011011010011101010011100100111010110000010111100110111101111" &
   "010011010100010001101001011010011000001101011111111111100000101111000111" &
   "010011010011101011000000010000011011101000001000100111110111011101110110" &
   "010011010001010000011001001101010110101001110000111101100001011001111101" &
   "010011001110110110000101100000010111100001001110100101101101011111111110" &
   "010011000101001100001111011001001010101001111010010000110011100100001110" &
   "010010011110011010011101000101100100000011001100011100010011010010000111");

  CONSTANT     CORDIC_PACK_pi_rads_const : STD_LOGIC_VECTOR(CORDIC_PACK_max_rom_width-1 DOWNTO 0) :=
  "011001001000011111101101010100010001000010110100011000010001101001100010";

  CONSTANT CORDIC_PACK_pi_3_4_rads_const : STD_LOGIC_VECTOR(CORDIC_PACK_max_rom_width-1 DOWNTO 0) :=
  "010010110110010111110001111111001100110010000111010010001101001111001010";

  CONSTANT CORDIC_PACK_pi_2_4_rads_const : STD_LOGIC_VECTOR(CORDIC_PACK_max_rom_width-1 DOWNTO 0) :=
  "001100100100001111110110101010001000100001011010001100001000110100110010";

  CONSTANT CORDIC_PACK_pi_1_4_rads_const : STD_LOGIC_VECTOR(CORDIC_PACK_max_rom_width-1 DOWNTO 0) :=
  "000110010010000111111011010101000100010000101101000110000100011010011000";

  CONSTANT CORDIC_PACK_neg_pi_rads_const : STD_LOGIC_VECTOR(CORDIC_PACK_max_rom_width-1 DOWNTO 0) :=
  "100110110111100000010010101011101110111101001011100111101110010110011110";

  CONSTANT CORDIC_PACK_neg_pi_3_4_rads_const : STD_LOGIC_VECTOR(CORDIC_PACK_max_rom_width-1 DOWNTO 0) :=
  "101101001001101000001110000000110011001101111000101101110010110000110110";

  CONSTANT CORDIC_PACK_neg_pi_2_4_rads_const : STD_LOGIC_VECTOR(CORDIC_PACK_max_rom_width-1 DOWNTO 0) :=
  "110011011011110000001001010101110111011110100101110011110111001011001110";

  CONSTANT CORDIC_PACK_neg_pi_1_4_rads_const : STD_LOGIC_VECTOR(CORDIC_PACK_max_rom_width-1 DOWNTO 0) :=
  "111001101101111000000100101010111011101111010010111001111011100101101000";

  CONSTANT CORDIC_PACK_neg_pi_jrads_const : STD_LOGIC_VECTOR(CORDIC_PACK_max_rom_width-1 DOWNTO 0) :=
  "111000000000000000000000000000000000000000000000000000000000000000000000";

  CONSTANT CORDIC_PACK_neg_pi_3_4_jrads_const : STD_LOGIC_VECTOR(CORDIC_PACK_max_rom_width-1 DOWNTO 0) :=
  "111010000000000000000000000000000000000000000000000000000000000000000000";

  CONSTANT CORDIC_PACK_neg_pi_2_4_jrads_const : STD_LOGIC_VECTOR(CORDIC_PACK_max_rom_width-1 DOWNTO 0) :=
  "111100000000000000000000000000000000000000000000000000000000000000000000";

  CONSTANT CORDIC_PACK_neg_pi_1_4_jrads_const : STD_LOGIC_VECTOR(CORDIC_PACK_max_rom_width-1 DOWNTO 0) :=
  "111110000000000000000000000000000000000000000000000000000000000000000000";

  CONSTANT CORDIC_PACK_zero_const : STD_LOGIC_VECTOR(CORDIC_PACK_max_rom_width-1 DOWNTO 0) :=
  "000000000000000000000000000000000000000000000000000000000000000000000000";

  CONSTANT CORDIC_PACK_atan_rads : STD_LOGIC_VECTOR(CORDIC_PACK_max_rom_width*CORDIC_PACK_max_rom_length-1 DOWNTO 0) :=
  ("000000000000000000000000000000000000000000000000000000000000000000100000" &
   "000000000000000000000000000000000000000000000000000000000000000001000000" &
   "000000000000000000000000000000000000000000000000000000000000000010000000" &
   "000000000000000000000000000000000000000000000000000000000000000100000000" &
   "000000000000000000000000000000000000000000000000000000000000001000000000" &
   "000000000000000000000000000000000000000000000000000000000000010000000000" &
   "000000000000000000000000000000000000000000000000000000000000100000000000" &
   "000000000000000000000000000000000000000000000000000000000001000000000000" &
   "000000000000000000000000000000000000000000000000000000000010000000000000" &
   "000000000000000000000000000000000000000000000000000000000100000000000000" &
   "000000000000000000000000000000000000000000000000000000001000000000000000" &
   "000000000000000000000000000000000000000000000000000000010000000000000000" &
   "000000000000000000000000000000000000000000000000000000100000000000000000" &
   "000000000000000000000000000000000000000000000000000001000000000000000000" &
   "000000000000000000000000000000000000000000000000000010000000000000000000" &
   "000000000000000000000000000000000000000000000000000100000000000000000000" &
   "000000000000000000000000000000000000000000000000001000000000000000000000" &
   "000000000000000000000000000000000000000000000000010000000000000000000000" &
   "000000000000000000000000000000000000000000000000100000000000000000000000" &
   "000000000000000000000000000000000000000000000001000000000000000000000000" &
   "000000000000000000000000000000000000000000000010000000000000000000000000" &
   "000000000000000000000000000000000000000000000100000000000000000000000000" &
   "000000000000000000000000000000000000000000001000000000000000000000000000" &
   "000000000000000000000000000000000000000000010000000000000000000000000000" &
   "000000000000000000000000000000000000000000100000000000000000000000000000" &
   "000000000000000000000000000000000000000001000000000000000000000000000000" &
   "000000000000000000000000000000000000000010000000000000000000000000000000" &
   "000000000000000000000000000000000000000100000000000000000000000000000000" &
   "000000000000000000000000000000000000001000000000000000000000000000000000" &
   "000000000000000000000000000000000000010000000000000000000000000000000000" &
   "000000000000000000000000000000000000100000000000000000000000000000000000" &
   "000000000000000000000000000000000001000000000000000000000000000000000000" &
   "000000000000000000000000000000000010000000000000000000000000000000000000" &
   "000000000000000000000000000000000100000000000000000000000000000000000000" &
   "000000000000000000000000000000001000000000000000000000000000000000000000" &
   "000000000000000000000000000000010000000000000000000000000000000000000000" &
   "000000000000000000000000000000100000000000000000000000000000000000000000" &
   "000000000000000000000000000001000000000000000000000000000000000000000000" &
   "000000000000000000000000000010000000000000000000000000000000000000000000" &
   "000000000000000000000000000100000000000000000000000000000000000000000000" &
   "000000000000000000000000001000000000000000000000000000000000000000000000" &
   "000000000000000000000000010000000000000000000000000000000000000000000000" &
   "000000000000000000000000011111111111111111111111111111111111111111111101" &
   "000000000000000000000000111111111111111111111111111111111111111111101011" &
   "000000000000000000000001111111111111111111111111111111111111111101010101" &
   "000000000000000000000011111111111111111111111111111111111111101010101011" &
   "000000000000000000000111111111111111111111111111111111111101010101010101" &
   "000000000000000000001111111111111111111111111111111111101010101010101011" &
   "000000000000000000011111111111111111111111111111111101010101010101010101" &
   "000000000000000000111111111111111111111111111111101010101010101010101011" &
   "000000000000000001111111111111111111111111111101010101010101010101010101" &
   "000000000000000011111111111111111111111111101010101010101010101010101110" &
   "000000000000000111111111111111111111111101010101010101010101010110111100" &
   "000000000000001111111111111111111111101010101010101010101011011101110111" &
   "000000000000011111111111111111111101010101010101010101101110111011101111" &
   "000000000000111111111111111111101010101010101010110111011101110111010101" &
   "000000000001111111111111111101010101010101011011101110111011011100101001" &
   "000000000011111111111111101010101010101101110111011101010010111001011010" &
   "000000000111111111111101010101010110111011101101110010100110101011011110" &
   "000000001111111111101010101011011101110101001011101100010010010101000010" &
   "000000011111111101010101101110110111001011001111110111101001110001101101" &
   "000000111111101010110111010100110101010110000101111011011011100011001011" &
   "000001111101011011011101011111100100101100100000001101110101100010101011" &
   "000011101101011000110011100000101011000011011101101001111100010010000110");

  CONSTANT CORDIC_PACK_atan_jrads : STD_LOGIC_VECTOR(CORDIC_PACK_max_rom_width*CORDIC_PACK_max_rom_length-1 DOWNTO 0) :=
  ("000000000000000000000000000000000000000000000000000000000000000000001010" &
   "000000000000000000000000000000000000000000000000000000000000000000010100" &
   "000000000000000000000000000000000000000000000000000000000000000000101000" &
   "000000000000000000000000000000000000000000000000000000000000000001010001" &
   "000000000000000000000000000000000000000000000000000000000000000010100011" &
   "000000000000000000000000000000000000000000000000000000000000000101000110" &
   "000000000000000000000000000000000000000000000000000000000000001010001100" &
   "000000000000000000000000000000000000000000000000000000000000010100011000" &
   "000000000000000000000000000000000000000000000000000000000000101000101111" &
   "000000000000000000000000000000000000000000000000000000000001010001011111" &
   "000000000000000000000000000000000000000000000000000000000010100010111110" &
   "000000000000000000000000000000000000000000000000000000000101000101111101" &
   "000000000000000000000000000000000000000000000000000000001010001011111001" &
   "000000000000000000000000000000000000000000000000000000010100010111110011" &
   "000000000000000000000000000000000000000000000000000000101000101111100110" &
   "000000000000000000000000000000000000000000000000000001010001011111001100" &
   "000000000000000000000000000000000000000000000000000010100010111110011000" &
   "000000000000000000000000000000000000000000000000000101000101111100110000" &
   "000000000000000000000000000000000000000000000000001010001011111001100001" &
   "000000000000000000000000000000000000000000000000010100010111110011000001" &
   "000000000000000000000000000000000000000000000000101000101111100110000011" &
   "000000000000000000000000000000000000000000000001010001011111001100000111" &
   "000000000000000000000000000000000000000000000010100010111110011000001101" &
   "000000000000000000000000000000000000000000000101000101111100110000011011" &
   "000000000000000000000000000000000000000000001010001011111001100000110111" &
   "000000000000000000000000000000000000000000010100010111110011000001101110" &
   "000000000000000000000000000000000000000000101000101111100110000011011011" &
   "000000000000000000000000000000000000000001010001011111001100000110110111" &
   "000000000000000000000000000000000000000010100010111110011000001101101110" &
   "000000000000000000000000000000000000000101000101111100110000011011011100" &
   "000000000000000000000000000000000000001010001011111001100000110110111001" &
   "000000000000000000000000000000000000010100010111110011000001101101110010" &
   "000000000000000000000000000000000000101000101111100110000011011011100101" &
   "000000000000000000000000000000000001010001011111001100000110110111001010" &
   "000000000000000000000000000000000010100010111110011000001101101110010011" &
   "000000000000000000000000000000000101000101111100110000011011011100100111" &
   "000000000000000000000000000000001010001011111001100000110110111001001110" &
   "000000000000000000000000000000010100010111110011000001101101110010011100" &
   "000000000000000000000000000000101000101111100110000011011011100100111001" &
   "000000000000000000000000000001010001011111001100000110110111001001110010" &
   "000000000000000000000000000010100010111110011000001101101110010011100100" &
   "000000000000000000000000000101000101111100110000011011011100100111001000" &
   "000000000000000000000000001010001011111001100000110110111001001110010000" &
   "000000000000000000000000010100010111110011000001101101110010011100011011" &
   "000000000000000000000000101000101111100110000011011011100100111000001101" &
   "000000000000000000000001010001011111001100000110110111001001101011010101" &
   "000000000000000000000010100010111110011000001101101110010010101101111011" &
   "000000000000000000000101000101111100110000011011011100100000010101111010" &
   "000000000000000000001010001011111001100000110110111000010111111100001110" &
   "000000000000000000010100010111110011000001101101101011101001111011101101" &
   "000000000000000000101000101111100110000011011010101110100100010001010110" &
   "000000000000000001010001011111001100000110110000010111001011110010010001" &
   "000000000000000010100010111110011000001100110111111110110001100001100110" &
   "000000000000000101000101111100110000010100101010000000110010110111000010" &
   "000000000000001010001011111001100000000000100100011011101001111011011010" &
   "000000000000010100010111110010111010111011001100001010101100110111101110" &
   "000000000000101000101111100101001101000110110100001100001100110110111111" &
   "000000000001010001011111000101010100010001110101000100001010101110101000" &
   "000000000010100010111101100001111001011100001010000010011000101001100001" &
   "000000000101000101110101111110000101011001000001000110001001111000010101" &
   "000000001010001011000011010100001100001110010110001001101011101100110000" &
   "000000010100010001000100011101010000011101110111011001101000011011100000" &
   "000000100111111011001110000101101101011110111000111001111010001101111000" &
   "000001001011100100000001010001110110011101111100110000100001111010111100");

  CONSTANT CORDIC_PACK_atanh_rads : STD_LOGIC_VECTOR(CORDIC_PACK_max_rom_width*CORDIC_PACK_max_rom_length-1 DOWNTO 0) :=
  ("000000000000000000000000000000000000000000000000000000000000000000100000" &
   "000000000000000000000000000000000000000000000000000000000000000001000000" &
   "000000000000000000000000000000000000000000000000000000000000000010000000" &
   "000000000000000000000000000000000000000000000000000000000000000100000000" &
   "000000000000000000000000000000000000000000000000000000000000001000000000" &
   "000000000000000000000000000000000000000000000000000000000000010000000000" &
   "000000000000000000000000000000000000000000000000000000000000100000000000" &
   "000000000000000000000000000000000000000000000000000000000001000000000000" &
   "000000000000000000000000000000000000000000000000000000000010000000000000" &
   "000000000000000000000000000000000000000000000000000000000100000000000000" &
   "000000000000000000000000000000000000000000000000000000001000000000000000" &
   "000000000000000000000000000000000000000000000000000000010000000000000000" &
   "000000000000000000000000000000000000000000000000000000100000000000000000" &
   "000000000000000000000000000000000000000000000000000001000000000000000000" &
   "000000000000000000000000000000000000000000000000000010000000000000000000" &
   "000000000000000000000000000000000000000000000000000100000000000000000000" &
   "000000000000000000000000000000000000000000000000001000000000000000000000" &
   "000000000000000000000000000000000000000000000000010000000000000000000000" &
   "000000000000000000000000000000000000000000000000100000000000000000000000" &
   "000000000000000000000000000000000000000000000001000000000000000000000000" &
   "000000000000000000000000000000000000000000000010000000000000000000000000" &
   "000000000000000000000000000000000000000000000100000000000000000000000000" &
   "000000000000000000000000000000000000000000001000000000000000000000000000" &
   "000000000000000000000000000000000000000000010000000000000000000000000000" &
   "000000000000000000000000000000000000000000100000000000000000000000000000" &
   "000000000000000000000000000000000000000001000000000000000000000000000000" &
   "000000000000000000000000000000000000000010000000000000000000000000000000" &
   "000000000000000000000000000000000000000100000000000000000000000000000000" &
   "000000000000000000000000000000000000001000000000000000000000000000000000" &
   "000000000000000000000000000000000000010000000000000000000000000000000000" &
   "000000000000000000000000000000000000100000000000000000000000000000000000" &
   "000000000000000000000000000000000001000000000000000000000000000000000000" &
   "000000000000000000000000000000000010000000000000000000000000000000000000" &
   "000000000000000000000000000000000100000000000000000000000000000000000000" &
   "000000000000000000000000000000001000000000000000000000000000000000000000" &
   "000000000000000000000000000000010000000000000000000000000000000000000000" &
   "000000000000000000000000000000100000000000000000000000000000000000000000" &
   "000000000000000000000000000001000000000000000000000000000000000000000000" &
   "000000000000000000000000000010000000000000000000000000000000000000000000" &
   "000000000000000000000000000100000000000000000000000000000000000000000000" &
   "000000000000000000000000001000000000000000000000000000000000000000000000" &
   "000000000000000000000000010000000000000000000000000000000000000000000000" &
   "000000000000000000000000100000000000000000000000000000000000000000000011" &
   "000000000000000000000001000000000000000000000000000000000000000000010101" &
   "000000000000000000000010000000000000000000000000000000000000000010101011" &
   "000000000000000000000100000000000000000000000000000000000000010101010101" &
   "000000000000000000001000000000000000000000000000000000000010101010101011" &
   "000000000000000000010000000000000000000000000000000000010101010101010101" &
   "000000000000000000100000000000000000000000000000000010101010101010101011" &
   "000000000000000001000000000000000000000000000000010101010101010101010101" &
   "000000000000000010000000000000000000000000000010101010101010101010101011" &
   "000000000000000100000000000000000000000000010101010101010101010101011000" &
   "000000000000001000000000000000000000000010101010101010101010101100010001" &
   "000000000000010000000000000000000000010101010101010101010110001000100010" &
   "000000000000100000000000000000000010101010101010101011000100010001000100" &
   "000000000001000000000000000000010101010101010101100010001000100010010010" &
   "000000000010000000000000000010101010101010110001000100010001010110100011" &
   "000000000100000000000000010101010101011000100010001001000110101101001110" &
   "000000001000000000000010101010101100010001000101011010001110010011000111" &
   "000000010000000000010101010110001000100100011010111011100010010010110100" &
   "000000100000000010101011000100010101101001101110101101011001101110010110" &
   "000001000000010101100010010001110010011110101011101111011101101001100101" &
   "000010000010110001010111011111010100000010001010001010001101001110010100" &
   "000100011001001111101010011110101010110100000011000010100111110011111001");

  CONSTANT CORDIC_PACK_atanh_jrads : STD_LOGIC_VECTOR(CORDIC_PACK_max_rom_width*CORDIC_PACK_max_rom_length-1 DOWNTO 0) :=
  ("000000000000000000000000000000000000000000000000000000000000000000001010" &
   "000000000000000000000000000000000000000000000000000000000000000000010100" &
   "000000000000000000000000000000000000000000000000000000000000000000101000" &
   "000000000000000000000000000000000000000000000000000000000000000001010001" &
   "000000000000000000000000000000000000000000000000000000000000000010100011" &
   "000000000000000000000000000000000000000000000000000000000000000101000110" &
   "000000000000000000000000000000000000000000000000000000000000001010001100" &
   "000000000000000000000000000000000000000000000000000000000000010100011000" &
   "000000000000000000000000000000000000000000000000000000000000101000101111" &
   "000000000000000000000000000000000000000000000000000000000001010001011111" &
   "000000000000000000000000000000000000000000000000000000000010100010111110" &
   "000000000000000000000000000000000000000000000000000000000101000101111101" &
   "000000000000000000000000000000000000000000000000000000001010001011111001" &
   "000000000000000000000000000000000000000000000000000000010100010111110011" &
   "000000000000000000000000000000000000000000000000000000101000101111100110" &
   "000000000000000000000000000000000000000000000000000001010001011111001100" &
   "000000000000000000000000000000000000000000000000000010100010111110011000" &
   "000000000000000000000000000000000000000000000000000101000101111100110000" &
   "000000000000000000000000000000000000000000000000001010001011111001100000" &
   "000000000000000000000000000000000000000000000000010100010111110011000001" &
   "000000000000000000000000000000000000000000000000101000101111100110000011" &
   "000000000000000000000000000000000000000000000001010001011111001100000111" &
   "000000000000000000000000000000000000000000000010100010111110011000001101" &
   "000000000000000000000000000000000000000000000101000101111100110000011011" &
   "000000000000000000000000000000000000000000001010001011111001100000110111" &
   "000000000000000000000000000000000000000000010100010111110011000001101110" &
   "000000000000000000000000000000000000000000101000101111100110000011011011" &
   "000000000000000000000000000000000000000001010001011111001100000110110111" &
   "000000000000000000000000000000000000000010100010111110011000001101101110" &
   "000000000000000000000000000000000000000101000101111100110000011011011100" &
   "000000000000000000000000000000000000001010001011111001100000110110111001" &
   "000000000000000000000000000000000000010100010111110011000001101101110010" &
   "000000000000000000000000000000000000101000101111100110000011011011100101" &
   "000000000000000000000000000000000001010001011111001100000110110111001010" &
   "000000000000000000000000000000000010100010111110011000001101101110010011" &
   "000000000000000000000000000000000101000101111100110000011011011100100111" &
   "000000000000000000000000000000001010001011111001100000110110111001001110" &
   "000000000000000000000000000000010100010111110011000001101101110010011100" &
   "000000000000000000000000000000101000101111100110000011011011100100111001" &
   "000000000000000000000000000001010001011111001100000110110111001001110010" &
   "000000000000000000000000000010100010111110011000001101101110010011100100" &
   "000000000000000000000000000101000101111100110000011011011100100111001000" &
   "000000000000000000000000001010001011111001100000110110111001001110010010" &
   "000000000000000000000000010100010111110011000001101101110010011100101001" &
   "000000000000000000000000101000101111100110000011011011100100111001111010" &
   "000000000000000000000001010001011111001100000110110111001001111000111010" &
   "000000000000000000000010100010111110011000001101101110010100011010100101" &
   "000000000000000000000101000101111100110000011011011100101101111011000111" &
   "000000000000000000001010001011111001100000110110111010000100100101110100" &
   "000000000000000000010100010111110011000001101101111001001111001000011000" &
   "000000000000000000101000101111100110000011011100011011001101110110110100" &
   "000000000000000001010001011111001100000110111101111100011000011110000101" &
   "000000000000000010100010111110011000001110100100101000010111000000000101" &
   "000000000000000101000101111100110000100010001111001101011110101010111001" &
   "000000000000001010001011111001100001101101001110000001001000011010010001" &
   "000000000000010100010111110011001000100000011000110110100000101110110010" &
   "000000000000101000101111100110111001110000011001101010101011111010010101" &
   "000000000001010001011111010010111001011110100000111000011000111110011000" &
   "000000000010100010111111001110100011000001101001001111110100011101111100" &
   "000000000101000110000011100011010010000110010010000101010101101000101111" &
   "000000001010001100101111111101110100100111000101100100011110011011011100" &
   "000000010100011110101001101111110000110110010010110011101110001001010111" &
   "000000101001101000000011010110000100100011111110110010011001011000110100" &
   "000001011001100001011110001000110111101101011100101111010000001101101110");

  function select_integer (
         i0  : integer;
         i1  : integer;
         sel : boolean)
         return integer;

  function select_string (
           i0  : string;
           i1  : string;
           sel : boolean)
           return string;

  function select_slv (
           i0  : std_logic_vector;
           i1  : std_logic_vector;
           sel : boolean)
           return std_logic_vector;

  function select_sl (
           i0  : std_logic;
           i1  : std_logic;
           sel : boolean)
           return std_logic;

  function ext_bus(input_bus: std_logic_vector; width:integer; sign: integer) return std_logic_vector;

  function pow(x,y: integer) return integer;


end cordic_v4_0_pack;

-------------------------------------------------------------------------------
package body cordic_v4_0_pack is

--------------------------------------------------------------------------------
--From:  ../../hdl/cordic_pack.vhd

  FUNCTION CORDIC_PACK_funct_has_port(cordic_funct, position: INTEGER) RETURN INTEGER IS
  --NOTE: Rewritten to be compatible with Rabassa
    --VARIABLE in_out_vect_v : STD_LOGIC_VECTOR(CORDIC_PACK_cordic_io_cnt-1 DOWNTO 0);
    type t_in_out_vect is array (CORDIC_PACK_cordic_io_cnt-1 DOWNTO 0) of integer;
    variable in_out_vect: t_in_out_vect;
    --VARIABLE in_out_bit_v : STD_LOGIC;
    --VARIABLE in_out_tmp_v : INTEGER;
  BEGIN
  	
    -- in_out_bit_v := '0';
    -- The in_out_vect represents the valid
    -- I/O for the selected CORDIC function.
    -- "X_IN,Y_IN,PHA_IN,X_OUT,Y_OUT,PHA_OUT" 
    IF cordic_funct = CORDIC_PACK_f_rotate THEN
      -- in_out_vect_v := "111110";
      in_out_vect(0):=0;--PHA_OUT
      in_out_vect(1):=1;--Y_OUT
      in_out_vect(2):=1;--X_OUT
      in_out_vect(3):=1;--PHA_IN
      in_out_vect(4):=1;--Y_IN
      in_out_vect(5):=1;--X_IN
    ELSIF cordic_funct = CORDIC_PACK_f_translate THEN
      -- in_out_vect_v := "110101";
      in_out_vect(0):=1;
      in_out_vect(1):=0;
      in_out_vect(2):=1;
      in_out_vect(3):=0;
      in_out_vect(4):=1;
      in_out_vect(5):=1;
    ELSIF ((cordic_funct = CORDIC_PACK_f_sin_cos) OR (cordic_funct = CORDIC_PACK_f_sinh_cosh)) THEN
      -- in_out_vect_v := "001110";
      in_out_vect(0):=0;
      in_out_vect(1):=1;
      in_out_vect(2):=1;
      in_out_vect(3):=1;
      in_out_vect(4):=0;
      in_out_vect(5):=0;
    ELSIF ((cordic_funct = CORDIC_PACK_f_atan) OR (cordic_funct = CORDIC_PACK_f_atanh)) THEN
      -- in_out_vect_v := "110001";
      in_out_vect(0):=1;
      in_out_vect(1):=0;
      in_out_vect(2):=0;
      in_out_vect(3):=0;
      in_out_vect(4):=1;
      in_out_vect(5):=1;
    ELSE --IF cordic_funct = CORDIC_PACK_f_sqrt THEN
      -- in_out_vect_v := "100100";
      in_out_vect(0):=0;
      in_out_vect(1):=0;
      in_out_vect(2):=1;
      in_out_vect(3):=0;
      in_out_vect(4):=0;
      in_out_vect(5):=1;
    END IF;
    -- in_out_bit_v := in_out_vect_v(position);

    -- IF (in_out_bit_v = '1') THEN
      -- in_out_tmp_v := 1;	
    -- ELSE -- (in_out_bit_v = '1')
      -- in_out_tmp_v := 0;
    -- END IF;    

    -- RETURN in_out_tmp_v;
    return in_out_vect(position);
  END; -- FUNCTION CORDIC_PACK_funct_has_port;

  FUNCTION CORDIC_PACK_get_transform_type(cordic_funct : INTEGER)RETURN INTEGER IS
    VARIABLE transform_type_v : INTEGER;
  BEGIN
  	IF ((cordic_funct = CORDIC_PACK_f_sinh_cosh) OR (cordic_funct = CORDIC_PACK_f_atanh)) THEN
      transform_type_v := CORDIC_PACK_hyp_transform;
    ELSE
      transform_type_v := CORDIC_PACK_trig_transform;
  	END IF; 
    RETURN transform_type_v; 
  END; -- FUNCTION CORDIC_PACK_get_transform_type;

  FUNCTION CORDIC_PACK_get_eng_mode(cordic_funct: INTEGER) RETURN STD_LOGIC IS
    VARIABLE engine_mode_v : STD_LOGIC;
  BEGIN
    IF((cordic_funct=CORDIC_PACK_f_translate)OR(cordic_funct=CORDIC_PACK_f_atan)OR
       (cordic_funct=CORDIC_PACK_f_atanh))THEN
      engine_mode_v := '1';
    ELSE
      engine_mode_v := '0';
    END IF;
    RETURN engine_mode_v;
  END; -- FUNCTION CORDIC_PACK_get_eng_mode

  FUNCTION CORDIC_PACK_get_iterations_int(coarse_rotate : INTEGER; cordic_funct : INTEGER; iterations : INTEGER; 
             output_width : INTEGER; round_mode : INTEGER) RETURN INTEGER IS
    VARIABLE iterations_int_v : INTEGER;
    VARIABLE iterations_v : INTEGER;
    VARIABLE rnd_mode_int_v : INTEGER;
  BEGIN
    --If the user selects a number of iterations, ie iterations /= 0, use this.
    IF (iterations /= 0) THEN
      iterations_v := iterations;
    --Otherwise Calcualte appropriate precision.
    ELSE -- iterations = 0
      IF (cordic_funct /= CORDIC_PACK_f_sqrt) THEN
        IF (coarse_rotate = 1) THEN
          iterations_int_v := output_width-2;
        ELSE
          iterations_int_v := output_width;
        END IF;
        IF (CORDIC_PACK_get_transform_type(cordic_funct) = CORDIC_PACK_hyp_transform) THEN
          IF (iterations_int_v >= 13) THEN iterations_v := iterations_int_v + 2;
          ELSIF (iterations_int_v >= 4) THEN iterations_v := iterations_int_v + 1;
          ELSE iterations_v := iterations_int_v;
          END IF;
        ELSE
          iterations_v := iterations_int_v;
        END IF;
      ELSE
        rnd_mode_int_v := CORDIC_PACK_get_rnd_mode_int(cordic_funct,round_mode);
        iterations_v := output_width + CORDIC_PACK_get_round_ext(rnd_mode_int_v);
      END IF;
    END IF;
    RETURN iterations_v;
  END; -- FUNCTION CORDIC_PACK_get_iterations_int;

  FUNCTION CORDIC_PACK_get_sqrt_output_width(input_width : INTEGER; output_width : INTEGER; data_format : INTEGER) RETURN INTEGER IS
    VARIABLE output_width_v : INTEGER;
  BEGIN
    IF data_format = CORDIC_PACK_format_usig_int THEN
      output_width_v := (input_width+2)/2;
    ELSE
      output_width_v := output_width;
    END IF;
    RETURN output_width_v;
  END; -- FUNCTION CORDIC_PACK_get_sqrt_output_width;

  FUNCTION CORDIC_PACK_get_precision_int(cordic_funct : INTEGER; data_format : INTEGER;input_width : INTEGER;
             iterations_int : INTEGER; output_width : INTEGER; precision : INTEGER; round_mode : INTEGER) RETURN INTEGER IS
    VARIABLE precision_v : INTEGER;
    VARIABLE rnd_mode_int_v : INTEGER;
    VARIABLE output_width_int_v : INTEGER; 
  BEGIN
    IF (precision /= 0) THEN
    --If the user selects a precision, ie precision /= 0, use this.
      precision_v := precision;
    -- Otherwise Calculate an appropriate precision
    ELSE --IF (precision = 0) THEN
      IF (cordic_funct /= CORDIC_PACK_f_sqrt) THEN
        --precision_v := CORDIC_PACK_log2_rnd_up(iterations_int) + output_width;
        precision_v := log2roundup(iterations_int) + output_width;
      ELSE -- if cordic_funct = sqrt
        output_width_int_v := CORDIC_PACK_get_sqrt_output_width(input_width, output_width, data_format);
        IF (round_mode = CORDIC_PACK_round_truncate) THEN
          precision_v := output_width_int_v;
        ELSIF ((round_mode = CORDIC_PACK_round_pos_inf) OR (round_mode = CORDIC_PACK_round_pos_neg_inf)) THEN
          precision_v := output_width_int_v + 1;
        ELSE --(round_mode = CORDIC_PACK_round_nearest_even) THEN
          precision_v := output_width_int_v + 2;
        END IF;
      END IF;        
    END IF;
    RETURN precision_v;
  END; --FUNCTION CORDIC_PACK_get_precision_int;

  FUNCTION CORDIC_PACK_get_rnd_mode_int(cordic_funct : INTEGER; round_mode : INTEGER) RETURN INTEGER IS
    VARIABLE round_mode_v : INTEGER;
  BEGIN
    IF (cordic_funct = CORDIC_PACK_f_sqrt) AND (round_mode = CORDIC_PACK_round_pos_neg_inf) THEN
      round_mode_v := CORDIC_PACK_round_pos_inf;
    ELSE
      round_mode_v := round_mode;
    END IF;
    RETURN round_mode_v;
  END; --FUNCTION CORDIC_PACK_get_rnd_mode_int;

  FUNCTION CORDIC_PACK_gen_ctrl_width(coarse_rotate : INTEGER) RETURN INTEGER IS
    VARIABLE gen_ctrl_width_v : INTEGER;
  BEGIN
    IF (coarse_rotate = 1) THEN
      gen_ctrl_width_v := 3;
    ELSE
      gen_ctrl_width_v := 1;
    END IF;
    RETURN gen_ctrl_width_v;
  END; --FUNCTION CORDIC_PACK_gen_ctrl_width;

  FUNCTION CORDIC_PACK_get_current_iteration(I : INTEGER;transform_type : INTEGER)RETURN INTEGER IS 
    VARIABLE iteration_v : INTEGER;
  BEGIN
  	IF (transform_type = CORDIC_PACK_hyp_transform) THEN
      IF (I > 13) THEN iteration_v := I - 2;
      ELSIF (I > 3) THEN iteration_v := I - 1;
      ELSE iteration_v := I;
      END IF;
    ELSE
      iteration_v := I;
  	END IF; RETURN iteration_v; 
  END; --FUNCTION CORDIC_PACK_get_current_iteration;

  FUNCTION CORDIC_PACK_get_round_ext(round_mode : INTEGER) RETURN INTEGER IS
    VARIABLE rnd_ext_v : INTEGER;
  BEGIN
    IF (round_mode = CORDIC_PACK_round_truncate) THEN
      rnd_ext_v := 0;
    ELSIF (round_mode = CORDIC_PACK_round_pos_inf) THEN
      rnd_ext_v := 1;
    ELSIF (round_mode = CORDIC_PACK_round_pos_neg_inf) THEN
      rnd_ext_v := 2;
    ELSE -- (round_mode = CORDIC_PACK_round_nearest_even) THEN
      rnd_ext_v := 2;
    END IF;
    RETURN rnd_ext_v;
  END; --FUNCTION CORDIC_PACK_get_round_ext;

  FUNCTION CORDIC_PACK_get_rnd_pipe_int(p_pipeline_mode:INTEGER; p_reg_outputs:INTEGER)RETURN INTEGER IS
    VARIABLE rnd_pipe_mode_v : INTEGER;
  BEGIN
    IF (p_reg_outputs = 1) THEN
      rnd_pipe_mode_v := CORDIC_PACK_pipe_max; 	
    ELSE
      rnd_pipe_mode_v := p_pipeline_mode;
    END IF;
    RETURN rnd_pipe_mode_v;
  END; --FUNCTION CORDIC_PACK_get_rnd_pipe_int;

  FUNCTION CORDIC_PACK_get_ccm_imp(scale_comp : INTEGER) RETURN INTEGER is  
  begin
    case scale_comp is
      when CORDIC_PACK_scale_lut        => return DIST_MEM;
      when CORDIC_PACK_scale_bram       => return BRAM;
      when CORDIC_PACK_scale_emb_mult   => return MULTS;
      when others                       => return DIST_MEM;
    end case;
  end;

  FUNCTION getLatency(architecture_sel : INTEGER; coarse_rotate : INTEGER; cordic_function : INTEGER;
                      data_format : INTEGER; family : STRING; input_width : INTEGER; iterations : INTEGER; output_width : INTEGER;
                      pipeline_mode : INTEGER; precision : INTEGER; reg_inputs : INTEGER; reg_outputs: INTEGER;
                      round_mode : INTEGER; scale_comp : INTEGER)
                      RETURN INTEGER IS
    VARIABLE latency_v : INTEGER;
    VARIABLE iterations_int_v : INTEGER;
    VARIABLE precision_int_v : INTEGER;
    VARIABLE scale_comp_int_v : INTEGER;
  BEGIN
    iterations_int_v := CORDIC_PACK_get_iterations_int(coarse_rotate, cordic_function, iterations, output_width, 
                         round_mode);
    precision_int_v := CORDIC_PACK_get_precision_int(cordic_function, data_format, input_width, iterations_int_v, 
                         output_width, precision, round_mode);
    -- scale_comp_int_v := CORDIC_PACK_get_scale_comp_int(family, scale_comp);
    latency_v := 0;
    IF ((cordic_function = CORDIC_PACK_f_rotate) OR (cordic_function = CORDIC_PACK_f_sin_cos) OR
        (cordic_function = CORDIC_PACK_f_sinh_cosh) OR (cordic_function = CORDIC_PACK_f_translate) OR
        (cordic_function = CORDIC_PACK_f_atan) OR (cordic_function = CORDIC_PACK_f_atanh))
    THEN
        latency_v := latency_v + 
                     CORDIC_PACK_get_inp_config_latency(architecture_sel, coarse_rotate, cordic_function, 
                       pipeline_mode, reg_inputs) +
                     CORDIC_PACK_get_engine_latency(architecture_sel, iterations_int_v, pipeline_mode) +
                     CORDIC_PACK_get_out_config_latency(family,architecture_sel,coarse_rotate, cordic_function, 
                       iterations_int_v, pipeline_mode, precision_int_v, reg_outputs, round_mode, scale_comp);--scale_comp_int_v);
    END IF;
    IF (cordic_function = CORDIC_PACK_f_sqrt)
    THEN
      latency_v := CORDIC_PACK_get_sqrt_latency(data_format,input_width,output_width,pipeline_mode,precision_int_v,
                     reg_inputs,reg_outputs,round_mode);
    END IF;
    RETURN latency_v;
  END; --FUNCTION getLatency;

  FUNCTION CORDIC_PACK_get_inp_config_latency(architecture_sel : INTEGER; coarse_rotate : INTEGER; 
             cordic_function : INTEGER; pipeline_mode : INTEGER; reg_inputs : INTEGER)
             RETURN INTEGER IS
    VARIABLE latency_v : INTEGER;
  BEGIN
    latency_v := 0;
    IF (reg_inputs = 1) THEN
      latency_v := latency_v + 1;
    END IF;
    IF ( (coarse_rotate = 1) AND (architecture_sel = CORDIC_PACK_para_arch) AND
         ((pipeline_mode = CORDIC_PACK_pipe_max) OR (pipeline_mode = CORDIC_PACK_pipe_opt))
         ) THEN
      latency_v := latency_v + 2;    	
    END IF;
    RETURN latency_v;
  END; --FUNCTION CORDIC_PACK_get_inp_config_latency;

  FUNCTION CORDIC_PACK_get_engine_latency(architecture_sel : INTEGER; iterations_int : INTEGER; pipeline_mode : INTEGER)
    RETURN INTEGER IS
      VARIABLE latency_v : INTEGER;
  BEGIN
    latency_v := 0;
    IF ((pipeline_mode = CORDIC_PACK_pipe_opt) OR (pipeline_mode = CORDIC_PACK_pipe_max)) THEN
      latency_v := latency_v + iterations_int;
--      IF (architecture_sel = CORDIC_PACK_wser_arch) THEN
--        latency_v := latency_v + 1;
--      END IF;
    END IF;
    RETURN latency_v;
  END; --FUNCTION CORDIC_PACK_get_engine_latency;

  FUNCTION CORDIC_PACK_get_out_config_latency(family: string; architecture_sel : INTEGER; coarse_rotate : INTEGER; 
             cordic_function : INTEGER; iterations_int : INTEGER; pipeline_mode : INTEGER; precision_int : INTEGER;
             reg_outputs : INTEGER; round_mode : INTEGER; scale_comp_int : INTEGER) RETURN INTEGER IS
    VARIABLE latency_v : INTEGER;
    VARIABLE round_pipe_v : INTEGER;
  BEGIN
    latency_v := 0;
    -- Realign ND with Internal data for WSER Architecture.
    IF ( architecture_sel = CORDIC_PACK_wser_arch) THEN
      latency_v := latency_v + 2;
    END IF;
    --Coarse Output Rotation
    IF ( (coarse_rotate = 1) AND ((pipeline_mode = CORDIC_PACK_pipe_opt) OR (pipeline_mode = CORDIC_PACK_pipe_max)) ) THEN
      latency_v := latency_v + 2;
    END IF;
    --ccm_latency
    -- IF ((scale_comp_int = CORDIC_PACK_scale_ccm) OR (scale_comp_int = CORDIC_PACK_scale_block) OR 
        -- (scale_comp_int = CORDIC_PACK_scale_dsp48) ) THEN
    if scale_comp_int /= CORDIC_PACK_scale_none then
      latency_v := latency_v +
        CORDIC_PACK_get_scale_latency(family,cordic_function, precision_int, iterations_int, pipeline_mode,scale_comp_int,c_signed);
    END IF;
    --Cordic Round
    round_pipe_v := CORDIC_PACK_get_rnd_pipe_int(pipeline_mode, reg_outputs);
    latency_v := latency_v + CORDIC_PACK_get_round_latency(round_pipe_v,round_mode);
    RETURN latency_v;
  END; --FUNCTION CORDIC_PACK_get_out_config_latency

  FUNCTION CORDIC_PACK_get_scale_latency(family: string; cordic_function : INTEGER; precision_int : INTEGER; iterations_int : INTEGER;
                                 pipeline_mode: INTEGER; scale_comp_int: INTEGER; sign: integer)RETURN INTEGER IS
    -- VARIABLE mult_type_v : INTEGER;
    VARIABLE ccm_imp_v : INTEGER;
    VARIABLE scale_str_v : string(1 TO precision_int);
    VARIABLE scale_latency_v : INTEGER;
  BEGIN
  
    IF (pipeline_mode = CORDIC_PACK_pipe_none) THEN 
      scale_latency_v := 0;
    ELSE 
      -- mult_type_v := CORDIC_PACK_get_mult_type_int(scale_comp_int);
      ccm_imp_v := CORDIC_PACK_get_ccm_imp(scale_comp_int);
      
      scale_str_v := CORDIC_PACK_inv_cordic_scale_str(cordic_function,iterations_int,precision_int);

      -- gui trans_off
      scale_latency_v := mult_gen_v11_0_calc_fully_pipelined_latency (
                                              family,
                                              precision_int,--p_data_in_width, 
                                              sign,--p_data_type, 
                                              precision_int,--p_data_in_width, 
                                              c_unsigned, 
                                              FIXED_CCM, 
                                              1,--default taken from component definition 
                                              ccm_imp_v,
                                              scale_str_v);
      -- gui trans_on
      -- gui insert_on
      -- scale_latency_v := calc_fully_pipelined_latency_wrap (
                                              -- family,
                                              -- precision_int,
                                              -- sign,
                                              -- ccm_imp_v,
                                              -- scale_str_v);
      -- gui insert_off
    END IF;
    RETURN scale_latency_v;
  END; --FUNCTION CORDIC_PACK_get_scale_latency;

  FUNCTION CORDIC_PACK_get_round_latency(pipeline_mode : INTEGER; round_mode : INTEGER) RETURN INTEGER IS
    VARIABLE latency_v : INTEGER;
  BEGIN
    latency_v := 0;
    IF (pipeline_mode = CORDIC_PACK_pipe_none) -- No Pipelining 
    THEN
      latency_v := 0;
    ELSE
      latency_v := 1;
  	END IF;
    RETURN latency_v;
  END; --FUNCTION CORDIC_PACK_get_round_latency;

  FUNCTION CORDIC_PACK_get_sqrt_latency(data_format:INTEGER;input_width:INTEGER;output_width:INTEGER;
                      pipeline_mode:INTEGER;precision_int:INTEGER;reg_inputs:INTEGER; reg_outputs:INTEGER;
                      round_mode:INTEGER) RETURN INTEGER IS
    VARIABLE latency_v : INTEGER; 
  BEGIN
    latency_v := 0;
    --Optional input register
    IF reg_inputs = 1 THEN	latency_v := latency_v + 1; END IF;
    --Optimal Pipelining
    IF pipeline_mode = CORDIC_PACK_pipe_opt THEN
      latency_v := latency_v + (precision_int-1)/2 + 1;
    END IF;
    --Maximal Pipelining
    IF (pipeline_mode = CORDIC_PACK_pipe_max) THEN
    	latency_v := latency_v + precision_int-2 + 1;
    END IF;
    --Optional output register (note only require if engine is async)
    IF pipeline_mode = CORDIC_PACK_pipe_none THEN
      IF reg_outputs = 1 THEN
    	latency_v := latency_v + 1;
      END IF;
    END IF;
    RETURN latency_v;
  END; -- FUNCTION CORDIC_PACK_get_sqrt_latency;

  FUNCTION CORDIC_PACK_get_rfd_latency(architecture_sel : INTEGER;coarse_rotate : INTEGER;cordic_function : INTEGER;
                      iterations_int : INTEGER;pipeline_mode : INTEGER;reg_inputs : INTEGER) 
                      RETURN INTEGER IS
    VARIABLE latency_v : INTEGER;
  BEGIN
    latency_v := 0;
    IF (architecture_sel = CORDIC_PACK_wser_arch) THEN
      IF ( (cordic_function = CORDIC_PACK_f_rotate)    OR (cordic_function = CORDIC_PACK_f_sin_cos) OR
           (cordic_function = CORDIC_PACK_f_sinh_cosh) OR (cordic_function = CORDIC_PACK_f_translate) OR
           (cordic_function = CORDIC_PACK_f_atan)      OR (cordic_function = CORDIC_PACK_f_atanh) )
      THEN
        latency_v := latency_v +
                     CORDIC_PACK_get_inp_config_latency(architecture_sel, coarse_rotate, cordic_function,
                                            pipeline_mode, reg_inputs) +
                     CORDIC_PACK_get_engine_latency(architecture_sel, iterations_int, pipeline_mode);
      END IF;
    END IF;
    RETURN latency_v;
  END; --FUNCTION CORDIC_PACK_get_rfd_latency;

  FUNCTION CORDIC_PACK_slv_to_str(a: STD_LOGIC_VECTOR; len : INTEGER) RETURN STRING IS
    VARIABLE str_tmp_v : STRING(1 TO len);
  BEGIN
    FOR I IN len-1 DOWNTO 0 LOOP
      IF (a(I) = 'X') THEN str_tmp_v(len - I) := 'X';
      ELSIF (a(I) = 'Z') THEN str_tmp_v(len - I) := 'Z';
      ELSIF (a(I) = '0') THEN str_tmp_v(len - I) := '0';
      ELSIF (a(I) = '1') THEN str_tmp_v(len - I) := '1';
      ELSE str_tmp_v(len - I) := 'U'; END IF;
    END LOOP;
    RETURN str_tmp_v;
  END; -- FUNCTION CORDIC_PACK_slv_to_str;

  FUNCTION CORDIC_PACK_int_to_sl(a : INTEGER) RETURN STD_LOGIC IS
    VARIABLE int_to_sl_v : STD_LOGIC; 
  BEGIN 
    IF (a /= 0) THEN int_to_sl_v := '1'; ELSE int_to_sl_v := '0'; END IF; RETURN int_to_sl_v;
  END;-- FUNCTION CORDIC_PACK_int_to_sl;

  FUNCTION CORDIC_PACK_real_to_slv(a:REAL; len:INTEGER; fmt:INTEGER) RETURN STD_LOGIC_VECTOR IS
    VARIABLE a_int_v : REAL := 0.0;
    VARIABLE a_tmp_v : REAL := 0.0;
    VARIABLE pow_int_v : REAL := 0.0;
    VARIABLE pow_lsb_v : REAL := 0.0;
    VARIABLE a_vect_v: STD_LOGIC_VECTOR(len-1 DOWNTO 0);
  BEGIN
    pow_int_v := 1.0; FOR I IN fmt DOWNTO 1 LOOP pow_int_v := pow_int_v + pow_int_v; END LOOP;
    pow_lsb_v := pow_int_v; FOR I IN len-1 DOWNTO 1 LOOP pow_lsb_v := pow_lsb_v * 0.5; END LOOP; 
    IF ( a < -pow_int_v ) THEN
--      ASSERT FALSE REPORT "Real value too negative. Saturating output" SEVERITY warning;   
      a_int_v := pow_int_v;
    ELSIF (a >= pow_int_v) THEN
--      ASSERT FALSE REPORT "Real value too positive. Saturating output" SEVERITY warning;   
      a_int_v := pow_int_v - pow_lsb_v;
    ELSIF (a >= 0.0) THEN
      a_int_v := a;
    ELSE
      a_int_v := pow_int_v * 2.0 + a;
    END IF;
    FOR I IN len-1 DOWNTO 0 LOOP
      a_tmp_v := a_int_v - pow_int_v;
      IF (a_tmp_v >= REAL(0)) THEN
        a_vect_v(I) := '1';
    	  a_int_v := a_tmp_v;
      ELSE
        a_vect_v(I) := '0';
      END IF;
      pow_int_v := pow_int_v * 0.5;
    END LOOP;
    RETURN a_vect_v;
  END; -- FUNCTION CORDIC_PACK_real_to_slv;      

  FUNCTION CORDIC_PACK_slv_to_real(a:STD_LOGIC_VECTOR; len: INTEGER;fmt:Integer) RETURN REAL IS
    VARIABLE pow_int_v : REAL;
    VARIABLE pow_lsb_v : REAL;
    VARIABLE a_tmp_v : REAL;
    VARIABLE a_adj_v : REAL;
  BEGIN
    pow_int_v:= 1.0; FOR I IN fmt DOWNTO 1 LOOP pow_int_v := pow_int_v + pow_int_v; END LOOP;
    pow_lsb_v:= pow_int_v; FOR I IN len-1 DOWNTO 1 LOOP pow_lsb_v := pow_lsb_v * 0.5; END LOOP; 
    IF (a(len-1) = '1') THEN a_adj_v := -pow_int_v;
    ELSE a_adj_v := 0.0; END IF;
    pow_int_v := pow_int_v * 0.5;
    a_tmp_v := 0.0;
    FOR I IN len-2 DOWNTO 0 LOOP
      IF a(I) = '1' THEN
        a_tmp_v := a_tmp_v + pow_int_v;
      END IF;
      pow_int_v := pow_int_v * 0.5;
    END LOOP;
    a_tmp_v := a_tmp_v + a_adj_v;
    RETURN a_tmp_v;
  END; -- FUNCTION CORDIC_PACK_slv_to_real;      

  FUNCTION CORDIC_PACK_rnd_slv(a : IN STD_LOGIC_VECTOR; len : IN INTEGER; mode : IN INTEGER; precision : IN INTEGER) 
       RETURN STD_LOGIC_VECTOR IS
    VARIABLE a_int_v : STD_LOGIC_VECTOR(len DOWNTO 0);
    VARIABLE adj_v : STD_LOGIC_VECTOR(len DOWNTO 0);
    VARIABLE rnd_ext_v : STD_LOGIC_VECTOR(len DOWNTO 0);
    VARIABLE rnd_v : STD_LOGIC_VECTOR(precision - 1 DOWNTO 0);
    
  BEGIN

  --    ASSERT len >= precision REPORT "Error: Length of input vector is less than required precison" SEVERITY error;   

    FOR I IN len-1 DOWNTO 0 LOOP 
      a_int_v(I+1) := a(I);
    END LOOP;
    a_int_v(0) := '0';

    FOR I IN len DOWNTO 0 LOOP
      IF (mode = CORDIC_PACK_round_truncate) THEN
        adj_v(I) := '0';
      ELSE
        IF ( ((mode = CORDIC_PACK_round_pos_neg_inf) AND (a(len-1) = '1')) OR
             ((mode = CORDIC_PACK_round_nearest_even) AND (a(len-precision) = '1') AND (a(len-1) = '1')) OR
             ((mode = CORDIC_PACK_round_nearest_even) AND (a(len-precision) = '0') AND (a(len-1) = '0')) ) THEN
          IF (I < len - precision) THEN
            adj_v(I) := '1';
          ELSE
            adj_v(I) := '0';
          END IF;
        ELSE
          IF (I = len - precision) THEN
            adj_v(I) := '1';
          ELSE
            adj_v(I) := '0';
          END IF;
        END IF;
      END IF;
    END LOOP;

    rnd_ext_v := CORDIC_PACK_add_sub_signed_slv(a_int_v, len+1, adj_v, len+1, '1', '0');
    FOR I IN precision-1 DOWNTO 0 LOOP rnd_v(I) := rnd_ext_v(len+1-precision+I); END LOOP;
    RETURN rnd_v;                 

  END; -- FUNCTION CORDIC_PACK_rnd_slv;

  FUNCTION CORDIC_PACK_add_sub_signed_slv(a : STD_LOGIC_VECTOR; a_len: INTEGER; b : STD_LOGIC_VECTOR; b_len: INTEGER; 
                                          add_nsub : STD_LOGIC; c : STD_LOGIC) RETURN STD_LOGIC_VECTOR IS
    CONSTANT c_length_int : INTEGER := get_max(a_len, b_len);
    VARIABLE a_int_v, b_int_v :STD_LOGIC_VECTOR(c_length_int-1 DOWNTO 0); 
    VARIABLE c_int_v : STD_LOGIC_VECTOR(c_length_int DOWNTO 0);
    VARIABLE a_xor_b_v : STD_LOGIC_VECTOR(c_length_int-1 DOWNTO 0);
    VARIABLE s_int_v : STD_LOGIC_VECTOR(c_length_int-1 DOWNTO 0);
  BEGIN

    FOR I IN c_length_int-1 DOWNTO 0 LOOP
      IF (I < a_len) THEN a_int_v(I) := a(I); ELSE a_int_v(I) := a(a_len-1); END IF;
      IF (add_nsub = '0') THEN
        IF (I < b_len) THEN 
          IF b(I) = '0' THEN b_int_v(I) := '1'; ELSE b_int_v(I) := '0'; END IF;
        ELSE
          IF b(b_len-1) = '0' THEN b_int_v(I) := '1'; ELSE b_int_v(I) := '0'; END IF;
        END IF;
      ELSE
        IF (I < b_len) THEN b_int_v(I) := b(I); ELSE b_int_v(I) := b(b_len-1); END IF;
      END IF;
    END LOOP;

    c_int_v(0) := c;
          
    FOR I IN 0 TO c_length_int-1 LOOP
      IF (((a_int_v(I) = '1') AND (b_int_v(I) = '1')) OR 
          ((a_int_v(I) = '1') AND (c_int_v(I) = '1')) OR
          ((b_int_v(I) = '1') AND (c_int_v(I) = '1'))) THEN
        c_int_v(I+1) := '1';
      ELSE
        c_int_v(I+1) := '0';
      END IF;
      IF (((a_int_v(I) = '1') AND (b_int_v(I) = '0')) OR
          ((a_int_v(I) = '0') AND (b_int_v(I) = '1'))) THEN
        a_xor_b_v(I) := '1';
      ELSE
        a_xor_b_v(I) := '0';
      END IF;
      IF (((a_xor_b_v(I) = '1') AND (c_int_v(I) = '0')) OR
          ((a_xor_b_v(I) = '0') AND (c_int_v(I) = '1'))) THEN
        s_int_v(I) := '1';
      ELSE
        s_int_v(I) := '0';
      END IF;      
    END LOOP;    
    RETURN s_int_v;
  END; --FUNCTION CORDIC_PACK_add_sub_signed_slv;

  FUNCTION CORDIC_PACK_cordic_scale_slv(cordic_funct : IN INTEGER; iterations_int : IN INTEGER; precision_int : IN INTEGER
                            ) RETURN STD_LOGIC_VECTOR IS
    VARIABLE cordic_scale_ext_v: STD_LOGIC_VECTOR(CORDIC_PACK_max_rom_width-1 DOWNTO 0);
    VARIABLE cordic_scale_v: STD_LOGIC_VECTOR(precision_int-1 DOWNTO 0);
  BEGIN
    IF ((cordic_funct /= CORDIC_PACK_f_sinh_cosh ) AND (cordic_funct /= CORDIC_PACK_f_atanh)) THEN 
      FOR I IN CORDIC_PACK_max_rom_width-1 DOWNTO 0 LOOP
        cordic_scale_ext_v(I) := 
          CORDIC_PACK_cordic_scale_trig_const_slv(CORDIC_PACK_max_rom_width * (iterations_int-1) +I);
      END LOOP;    
    ELSE -- Hyperbolic
      FOR I IN CORDIC_PACK_max_rom_width-1 DOWNTO 0 LOOP
        cordic_scale_ext_v(I) := 
          CORDIC_PACK_cordic_scale_hyp_const_slv(CORDIC_PACK_max_rom_width * (iterations_int-1) +I);
      END LOOP;    
    END IF;
    cordic_scale_v := CORDIC_PACK_rnd_slv(cordic_scale_ext_v, CORDIC_PACK_max_rom_width, 3, precision_int);
    RETURN cordic_scale_v;
  END; --FUNCTION CORDIC_PACK_cordic_scale_slv;

  FUNCTION CORDIC_PACK_inv_cordic_scale_slv(cordic_funct : IN INTEGER; iterations_int : IN INTEGER; precision_int : IN INTEGER) RETURN STD_LOGIC_VECTOR IS
    VARIABLE inv_cordic_scale_ext_v: STD_LOGIC_VECTOR(CORDIC_PACK_max_rom_width-1 DOWNTO 0);
    VARIABLE inv_cordic_scale_v: STD_LOGIC_VECTOR(precision_int-1 DOWNTO 0);
  BEGIN
    IF ((cordic_funct /= CORDIC_PACK_f_sinh_cosh ) AND (cordic_funct /= CORDIC_PACK_f_atanh)) THEN
      FOR I IN CORDIC_PACK_max_rom_width-1 DOWNTO 0 LOOP
        inv_cordic_scale_ext_v(I) := 
          CORDIC_PACK_inv_cordic_scale_trig_const_slv(CORDIC_PACK_max_rom_width * (iterations_int-1) +I);
      END LOOP;      
    ELSE -- Hyperbolic
      FOR I IN CORDIC_PACK_max_rom_width-1 DOWNTO 0 LOOP
        inv_cordic_scale_ext_v(I) := 
          CORDIC_PACK_inv_cordic_scale_hyp_const_slv(CORDIC_PACK_max_rom_width * (iterations_int-1) +I);
      END LOOP;
    END IF;
    inv_cordic_scale_v := CORDIC_PACK_rnd_slv(inv_cordic_scale_ext_v, CORDIC_PACK_max_rom_width, 3, precision_int);
    RETURN inv_cordic_scale_v;
  END; --FUNCTION CORDIC_PACK_inv_cordic_scale_slv;

  FUNCTION CORDIC_PACK_inv_cordic_scale_str(cordic_funct : IN INTEGER; iterations_int : IN INTEGER; precision_int : IN INTEGER) RETURN STRING IS
    VARIABLE inv_scale_v : STRING(1 TO precision_int);
  BEGIN
    inv_scale_v := CORDIC_PACK_slv_to_str(CORDIC_PACK_inv_cordic_scale_slv(cordic_funct,iterations_int,precision_int),precision_int);    
  	RETURN inv_scale_v;
  END; --FUNCTION CORDIC_PACK_inv_cordic_scale_str;

  FUNCTION CORDIC_PACK_rshift_slv(a : IN STD_LOGIC_VECTOR; shift : IN INTEGER) RETURN STD_LOGIC_VECTOR IS
    VARIABLE rshift_v : STD_LOGIC_VECTOR(a'length-1 DOWNTO 0); 
  BEGIN
    rshift_v := (others=>a(a'high));--CORDIC_BEH_set_vect_slv(rshift_v, a(a'high));	
    FOR I IN (a'length - shift -2) DOWNTO 0 LOOP
      rshift_v(I) := a(I+shift+a'low);	
    END LOOP;    
    RETURN rshift_v;
  END; --FUNCTION CORDIC_BEH_rshift_slv;

  FUNCTION check_generics ( c_architecture,
                            c_cordic_function,
                            c_coarse_rotate,
                            c_data_format,
                            c_has_ce,
                            c_has_clk,
                            c_has_nd,
                            c_has_phase_in,
                            c_has_phase_out,
                            c_has_rdy,
                            c_has_rfd,
                            c_has_sclr,
                            c_has_x_in,
                            c_has_x_out,
                            c_has_y_in,
                            c_has_y_out,
                            c_input_width,
                            c_iterations,
                            c_output_width,
                            c_phase_format,
                            c_pipeline_mode,
                            c_precision,
                            c_reg_inputs,
                            c_reg_outputs,
                            c_round_mode,
                            c_scale_comp
                            : integer) RETURN BOOLEAN IS
    
    VARIABLE status_int : BOOLEAN;
  BEGIN
    status_int := TRUE;
    
    --Basic range checks------------------------------------------------------------------------------------------------
    
    --boolean ranges
    status_int:=check_boolean_range(c_coarse_rotate,"c_coarse_rotate");
    status_int:=check_boolean_range(c_has_ce,       "c_has_ce");
    status_int:=check_boolean_range(c_has_clk,      "c_has_clk");
    status_int:=check_boolean_range(c_has_nd,       "c_has_nd");
    status_int:=check_boolean_range(c_has_phase_in, "c_has_phase_in");
    status_int:=check_boolean_range(c_has_phase_out,"c_has_phase_out");
    status_int:=check_boolean_range(c_has_rdy,      "c_has_rdy");
    status_int:=check_boolean_range(c_has_rfd,      "c_has_rfd");
    status_int:=check_boolean_range(c_has_sclr,     "c_has_sclr");
    status_int:=check_boolean_range(c_has_x_in,     "c_has_x_in");
    status_int:=check_boolean_range(c_has_x_out,    "c_has_x_out");
    status_int:=check_boolean_range(c_has_y_in,     "c_has_y_in");
    status_int:=check_boolean_range(c_has_y_out,    "c_has_y_out");
    status_int:=check_boolean_range(c_reg_inputs,   "c_reg_inputs");
    status_int:=check_boolean_range(c_reg_outputs,  "c_reg_outputs");
    
    -- input width check
    IF( c_input_width < 8 OR c_input_width > 48) THEN
       status_int := false;
       REPORT "ERROR: CORDIC v4.0: Input width must be between 8 and 48 " SEVERITY ERROR;
    END IF;
    
    -- output width check
    if ((c_cordic_function /= CORDIC_PACK_f_sqrt) or (c_data_format/=CORDIC_PACK_format_usig_int)) then
      IF( c_output_width < 8 OR c_output_width > 48) THEN
       status_int := false;
       REPORT "ERROR: CORDIC v4.0: Output width must be between 8 and 48 " SEVERITY ERROR;
      END IF;    
    else
      --Minimum value has to change as output width is fixed to int(input_width/2)+1 then unsigned integer format
      IF ((c_input_width/2+1) /= c_output_width) THEN
        status_int := false;
        REPORT "ERROR: CORDIC v4.0: Output Width is Incorrect, it must be: "&integer'image(c_input_width/2+1) SEVERITY ERROR;
      END IF;    
    end if;    
    
    -- iterations check
    IF( (c_iterations < 4 and c_iterations/=0 and c_architecture=CORDIC_PACK_wser_arch) OR c_iterations > 48) THEN
       status_int := false;
       REPORT "ERROR: CORDIC v4.0: c_iterations must be 0 or between 4 and 48 " SEVERITY ERROR;
    END IF;
    
    -- precision check
    IF( (c_precision < c_output_width and c_precision/=0) OR c_precision > 48) THEN
       status_int := false;
       REPORT "ERROR: CORDIC v4.0: c_precision must be 0 or between "&integer'image(c_output_width)&" and 48" SEVERITY ERROR;
    END IF;
    
    --Others
    if c_architecture<1 or c_architecture>2 then
      status_int := false;
      REPORT "ERROR: CORDIC v4.0: invalid value for c_architecture" SEVERITY ERROR;
    end if;
    if c_cordic_function<0 or c_cordic_function>6 then
      status_int := false;
      REPORT "ERROR: CORDIC v4.0: invalid value for c_cordic_function" SEVERITY ERROR;
    end if;
    if c_data_format<0 or c_data_format>2 then
      status_int := false;
      REPORT "ERROR: CORDIC v4.0: invalid value for c_data_format, valid values are 0,1,2." SEVERITY ERROR;
    end if;
    if c_phase_format<0 or c_phase_format>1 then
      status_int := false;
      REPORT "ERROR: CORDIC v4.0: invalid value for c_phase_format, valid values are 0,1." SEVERITY ERROR;
    end if;
    if c_pipeline_mode<-2 or c_pipeline_mode>0 then
      status_int := false;
      REPORT "ERROR: CORDIC v4.0: invalid value for c_pipeline_mode, valid values are 0,-1,-2." SEVERITY ERROR;
    end if;
    if c_round_mode<0 or c_round_mode>3 then
      status_int := false;
      REPORT "ERROR: CORDIC v4.0: invalid value for c_round_mode, valid values are in the range 0 to 3." SEVERITY ERROR;
    end if;
    if c_scale_comp<0 or c_scale_comp>3 then
      status_int := false;
      REPORT "ERROR: CORDIC v4.0: invalid value for c_scale_comp, valid values are in the range 0 to 3." SEVERITY ERROR;
    end if;
    
    --Configuration checks----------------------------------------------------------------------------------------------
    
    -- function-architecture checks
    IF(c_architecture = CORDIC_PACK_wser_arch and c_cordic_function = CORDIC_PACK_f_sqrt) THEN
       status_int := false;
       REPORT "ERROR: CORDIC v4.0: WSER architecture not avaliable for SQRT Function" SEVERITY ERROR;
    END IF;
    
    -- architecture-pipeline checks
    IF((c_architecture = CORDIC_PACK_wser_arch) and (c_pipeline_mode = CORDIC_PACK_pipe_none)) THEN
       status_int := false;
       REPORT "ERROR: CORDIC v4.0: CORDIC_PACK_pipe_none is an invalid option for WSER architecture" SEVERITY ERROR;
    END IF;
    -- function-scale_compensation checks
    IF(((c_cordic_function = CORDIC_PACK_f_sin_cos) OR (c_cordic_function = CORDIC_PACK_f_sinh_cosh) OR
        (c_cordic_function = CORDIC_PACK_f_atan) OR (c_cordic_function = CORDIC_PACK_f_atanh) OR
        (c_cordic_function = CORDIC_PACK_f_sqrt) ) AND (c_scale_comp /= CORDIC_PACK_scale_none) ) THEN
       status_int := false;
       REPORT "ERROR: CORDIC v4.0: Scaling is not required for selected Function" SEVERITY ERROR;
    END IF;    
    
    -- input port check
    IF(( c_has_x_in /= CORDIC_PACK_funct_has_port(c_cordic_function,5)) OR
       ( c_has_y_in /= CORDIC_PACK_funct_has_port(c_cordic_function,4)) OR
       ( c_has_phase_in /= CORDIC_PACK_funct_has_port(c_cordic_function,3)) ) THEN
       status_int := false;
       REPORT "ERROR: CORDIC v4.0: Input ports are inconsistent with Functional Configuration " SEVERITY ERROR;
    END IF;
    -- input port check
    IF( (c_cordic_function /= CORDIC_PACK_f_sqrt) AND
        (c_data_format /= CORDIC_PACK_format_sig_frac) ) THEN
      status_int := false;
      REPORT "ERROR: CORDIC v4.0: Data Format is inappropriate for cordic functional selection" SEVERITY ERROR;
    END IF;
        
    RETURN status_int;
  END FUNCTION check_generics;

function check_boolean_range( generic_value: integer; generic_string: string) return boolean is
begin
  if generic_value/=0 and generic_value/=1 then
    report "ERROR: CORDIC v4.0: "&generic_string&" can only take the value 0 or 1";
    return false;
  else
    return true;
  end if;
end check_boolean_range;

function select_integer (
         i0  : integer;
         i1  : integer;
         sel : boolean)
         return integer is
begin
  if sel then
    return i1;
  else
    return i0;
  end if; -- sel
end select_integer;

function select_string (
         i0  : string;
         i1  : string;
         sel : boolean)
         return string is
begin
  if sel then
    return i1;
  else
    return i0;
  end if; -- sel
end select_string;

function select_slv (
         i0  : std_logic_vector;
         i1  : std_logic_vector;
         sel : boolean)
         return std_logic_vector is
begin
  if sel then
    return i1;
  else
    return i0;
  end if; -- sel
end select_slv;

function select_sl (
         i0  : std_logic;
         i1  : std_logic;
         sel : boolean)
         return std_logic is
begin
  if sel then
    return i1;
  else
    return i0;
  end if; -- sel
end select_sl;

function ext_bus(input_bus: std_logic_vector; width:integer; sign: integer) return std_logic_vector is
variable return_bus: std_logic_vector(width-1 downto 0);
constant input_width:integer:=input_bus'high + 1 - input_bus'low;
begin

  if ( input_width< width ) then
    --extend or pad
    return_bus(input_width-1 downto 0):=input_bus;

    if (sign=c_signed) then --signed
      --extend remaing bits with sign
      return_bus((width-1) downto input_width) := (others=>input_bus(input_bus'high));
    else            --unsigned
      --pad remaing bits with 0
      return_bus((width-1) downto input_width) := (others=>'0');
    end if;

  elsif (input_width=width) then
    --same width
    return_bus := input_bus;
  else
    --larger
    return_bus := input_bus((width-1)+input_bus'low downto input_bus'low);
  end if;

  return return_bus;
end;

function pow(x,y: integer) return integer is
  variable power: integer:=x;
begin
  if x=2 then
    return 2**y;
  else
    if y=0 then
      return 1;
    elsif y=1 then
      return x;
    else
      for i in 1 to y-1 loop
        power:=power*x;
      end loop;    
      return power;
    end if;
  end if;
end;


end cordic_v4_0_pack;
